/**
  ******************************************************************************
  * @file    uart.c
  * @author  Puya Application Team
  * @brief   Contains USART HW configuration
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2021 Puya Semiconductor.
  * All rights reserved.</center></h2>
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "uart.h"
#include "wdg.h"

/**
  * @brief  This function is used to send one byte through USART pipe.
  * @param  ucDataBuf The byte to be sent.
  * @retval None.
  */
void UART_SendByte(uint8_t ucDataBuf)
{
  DEBUG_UART->DR = (ucDataBuf & (uint16_t)0x01FF);
  
  while (UART_SR_TXE != READ_BIT(DEBUG_UART->SR, UART_SR_TXE))
  {
    WDG_Refresh();
  }
  
  CLEAR_BIT(DEBUG_UART->SR, UART_SR_TXE);
}

/**
  * @brief  This function is used to read one byte from USART pipe.
  * @retval Returns the read byte.
  */
uint8_t UART_ReadByte(void)
{
  while (UART_SR_RXNE != READ_BIT(DEBUG_UART->SR, UART_SR_RXNE))
  {
    WDG_Refresh();
  }
  return (uint8_t)(READ_BIT(DEBUG_UART->DR, UART_DR_DR) & 0xFFU);
}

#ifdef _DEBUG
//重定向c库函数printf到串口DEBUG_USART，重定向后可使用printf函数
int fputc(int ch, FILE *f)
{
  /* 发送一个字节数据到串口DEBUG_USART */
  UART_SendByte(ch);

  return (ch);
}
#endif
